/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.fabric;

import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.impactdev.impactor.api.logging.Log4jLogger;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.impactdev.impactor.core.plugin.ImpactorBootstrapper;
import net.impactdev.impactor.fabric.FabricImpactorPlugin;
import net.impactdev.impactor.minecraft.api.items.ServerProvider;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;

public final class FabricImpactorBootstrap
extends ImpactorBootstrapper
implements ModInitializer {
    private static FabricImpactorBootstrap instance;
    private MinecraftServer server;

    public FabricImpactorBootstrap() {
        super(new Log4jLogger(LogManager.getLogger((String)"Impactor")));
        instance = this;
    }

    public static FabricImpactorBootstrap instance() {
        return instance;
    }

    @Override
    protected BaseImpactorPlugin createPlugin() {
        return new FabricImpactorPlugin(this);
    }

    public void onInitialize() {
        this.construct();
        ServerLifecycleEvents.SERVER_STARTING.register(this::onServerStarting);
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.shutdown());
    }

    private void onServerStarting(MinecraftServer server) {
        ServerProvider.server = this.server = server;
        this.setup();
        this.plugin.starting();
    }

    public Optional<MinecraftServer> server() {
        return Optional.ofNullable(this.server);
    }
}

